#pragma once
#include "Camera.h"
class StrafeCamera :
	public Camera
{
public:
	enum StrafeAxis
	{
		X,
		Y,
		Z
	};

	StrafeCamera(Vector3 origin, Vector3 pitchYawRoll, StrafeAxis axis, float min, float max);	//Initial position, initial pitch, yaw and roll, strafe axis, min strafe axis value, min strafe axis value
	StrafeCamera(Vector3 origin, Vector3 pitchYawRoll, float speed, StrafeAxis axis, float min, float max);	//Initial position, initial pitch, yaw and roll, speed, strafe axis, min strafe axis value, min strafe axis value
	~StrafeCamera();

	//Overrides
	void Animate(float dt) override;

	//Move functions are overridden to take into account the relative position the camera is facing and set the control scheme appropriately
	void MoveForward(float dt) override;
	void MoveRight(float dt) override;
	void MoveUp(float dt) override;

	//No rotation for strafe camera, these are overridden to do nothing
	void RotateX(float dt) override;
	void RotateY(float dt) override;
	void RotateZ(float dt) override;
	void RotateFromMouse(float xOffset, float yOffset, float dt) override;

private:
	StrafeAxis _StrafeAxis;	//Which axis we're strafing along
	float _MinimumAxisValue;	//Minimum value we can strafe to
	float _MaximumAxisValue;	//Maximum value we can strafe to

	void SetBoundsFromVals();	//Updates the bounds of the camera to reflect the min and max values set
};

